<?php
// source : https://openclassrooms.com/courses/propulsez-votre-site-avec-wordpress/creer-des-widgets
// ou
// cf livre Wordpress "Développez avec PHP" page 387
class Widget_Gabarit_Post extends WP_Widget{
    
    
    // Configuration
    function Widget_Gabarit_Post(){
        $widget_ops = array(
            'classname'   => 'widget-gabarit-post',
            'description' => 'Liste de gabarit et choix du post type',
        );
        
        $control_ops = array(
            'height'   => 350,
            'id_base'  => 'widget-gabarit-post',
        );

        $this->WP_Widget('widget-gabarit-post', 'Widget gabarit post', $widget_ops, $control_ops);
    }
    
    // Formulaire backend
    function form($instance){
        $defaults = '';
        $instance = wp_parse_args($instance, $defaults);
        global $gabarit;
        
        /***********
        *   GET POST TYPE
        ***************************************************/
        $exclude_cpts = array(
            'elementor_library'
        );
        // Post à faire integrer dans la liste
        $builtin = array(
            'post' => 'post'
        );
        // Tous les CPT
        $cpts = get_post_types( array(
            'public'   => true,
            '_builtin' => false
        ) );
        // remove Excluded CPTs from All CPTs.
        foreach($exclude_cpts as $exclude_cpt)
            unset($cpts[$exclude_cpt]);
        // Merge Builtin types and 'important' CPTs to resulting array to use as argument.
        $post_types = array_merge($builtin, $cpts);
        /******************************************************************************************/

?>

        <p>
            <label for="<?php echo $this->get_field_id('post-type');?>">Type de contenu :</label>
            <select id="<?php echo $this->get_field_id('post-type');?>" name="<?php echo $this->get_field_name('post-type');?>" value="<?php echo $instance['post-type'];?>" style="width:100%">
                <option selected disabled>Choisissez...</option>
                <?php 
                    foreach($post_types as $v){
                        if($instance['post-type']==$v){
                            $selected='selected="selected"';
                        }else{
                            $selected='';
                        }
                        echo '<option  value="'.$v.'">'.ucfirst($v).'</option>';
                    }
                ?>
            </select>
        </p>  
        <p>
            <label for="<?php echo $this->get_field_id('gabarit');?>">Gabarit :</label>
            <select id="<?php echo $this->get_field_id('gabarit');?>" name="<?php echo $this->get_field_name('gabarit');?>" value="<?php echo $instance['gabarit'];?>" style="width:100%">
                <option  value="defaut">Défaut</option>
              <?php 
                    foreach($gabarit as $k => $v){
                        if($instance['gabarit']==$v){
                            $selected='selected="selected"';
                        }else{
                            $selected='';
                        }
                        echo '<option  value="'.$k.'">'.$v.'</option>';
                    }
                ?>
            </select>
        </p>         
    <?php
    }
    
    // Mise à jour des options 
    function update($new_instance, $old_instance){
        
        $instance = $old_instance;
        $instance['post-type']      = strip_tags($new_instance['post-type']);
        $instance['gabarit']        = strip_tags($new_instance['gabarit']);
        
        return $instance;
    }
    
    // Rendre la vue
    function widget($args, $instance){
        
        extract($args);
        global $gabarit;
        
        
        if(!$instance['post-type']){
            echo '<h1>Choisissez votre type de contenu</h1>';
            return;
        }
        
        //$this->set_gabarit($instance['gabarit']);
        
        $get_gabarit = $instance['gabarit'];
        
        $this->$get_gabarit($instance['post-type']);
        
        
        
        /*echo 'vous avez choisis le post type : '.$instance['post-type'];
        echo '<br>';
        echo 'Faire donc appel au template "gabarit-'.$instance['gabarit'].'.php';*/

        /*        // 1. on défini ce que l'on veut
        $args = array(
            'post_type' => $instance['post-type'],
            'posts_per_page' => 10
        );

        // 2. on exécute la query
        $my_query = new WP_Query($args);

        // 3. on lance la boucle !
        if($my_query->have_posts()) : while ($my_query->have_posts() ) : $my_query->the_post();

            the_title();
            the_content();
            the_post_thumbnail();

        endwhile;
        endif;

        // 4. On réinitialise à la requête principale (important)
        wp_reset_postdata();*/
    }
    
    
    // Gabarit par défaut
    function defaut($post_type){
        
      // 1. on défini ce que l'on veut
        $args = array(
            'post_type' => $post_type,
            'posts_per_page' => 10
        );

        // 2. on exécute la query
        $my_query = new WP_Query($args);
        ?>
        <div class="container">
            <div class="row">
                <div class="col-md-12">

                    <?php
                        if ( $my_query->have_posts() ) :
                            while ( $my_query->have_posts() ) : $my_query->the_post();
                    ?>
                            <div id="post-<?php the_ID(); ?>" <?php post_class('sect'); ?>>
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php echo get_the_post_thumbnail(null, array(),array('class'=>'img-responsive'));?>
                                <?php get_the_post_thumbnail();?>
                                <p class="date_publish">Publié par <?php the_author();?> le <?php the_date();?> <?php wpweddu_edit_post( get_the_ID() ); ?></p> 
                                <p><?php the_excerpt(); ?></p>
                                <a class="btn btn-primary" href="<?php the_permalink(); ?>">Lire la suite<span class="glyphicon glyphicon-chevron-right"></span></a>
                            </div>
                    <?php
                            endwhile;
                        else :
                                get_template_part( 'template-parts/content', 'none' );

                        endif;
                    ?>
                </div>
            </div>
        </div>
        <?php
        // 4. On réinitialise à la requête principale (important)
        wp_reset_postdata();
        
    }
    
    function galerie($post_type){
        
        echo 'vous avez choisi le gabarit galerie';
        
    }
    
    function col_2($post_type){
        
      // 1. on défini ce que l'on veut
        $args = array(
            'post_type' => $post_type,
            'posts_per_page' => 10
        );

        // 2. on exécute la query
        $my_query = new WP_Query($args);
        ?>
        <div class="container">
            <div class="row">
                

                    <?php
                        if ( $my_query->have_posts() ) :
                            while ( $my_query->have_posts() ) : $my_query->the_post();
                    ?>
                         <div class="col-md-6">
                            <div id="post-<?php the_ID(); ?>" <?php post_class('sect'); ?>>
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php echo get_the_post_thumbnail(null, array(),array('class'=>'img-responsive'));?>
                                <?php get_the_post_thumbnail();?>
                                <p class="date_publish">Publié par <?php the_author();?> le <?php the_date();?> <?php wpweddu_edit_post( get_the_ID() ); ?></p> 
                                <p><?php the_excerpt(); ?></p>
                                <a class="btn btn-primary" href="<?php the_permalink(); ?>">Lire la suite<span class="glyphicon glyphicon-chevron-right"></span></a>
                            </div>
                        </div>
                    <?php
                            endwhile;
                        else :
                                get_template_part( 'template-parts/content', 'none' );

                        endif;
                    ?>
                
            </div>
        </div>
        <?php
        // 4. On réinitialise à la requête principale (important)
        wp_reset_postdata();
        
    }
    
    function col_3($post_type){
        
      // 1. on défini ce que l'on veut
        $args = array(
            'post_type' => $post_type,
            'posts_per_page' => 10
        );

        // 2. on exécute la query
        $my_query = new WP_Query($args);
        ?>
        <div class="container">
            <div class="row">
                

                    <?php
                        if ( $my_query->have_posts() ) :
                            while ( $my_query->have_posts() ) : $my_query->the_post();
                    ?>
                         <div class="col-md-4">
                            <div id="post-<?php the_ID(); ?>" <?php post_class('sect'); ?>>
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php echo get_the_post_thumbnail(null, array(),array('class'=>'img-responsive'));?>
                                <?php get_the_post_thumbnail();?>
                                <p class="date_publish">Publié par <?php the_author();?> le <?php the_date();?> <?php wpweddu_edit_post( get_the_ID() ); ?></p> 
                                <p><?php the_excerpt(); ?></p>
                                <a class="btn btn-primary" href="<?php the_permalink(); ?>">Lire la suite<span class="glyphicon glyphicon-chevron-right"></span></a>
                            </div>
                        </div>
                    <?php
                            endwhile;
                        else :
                                get_template_part( 'template-parts/content', 'none' );

                        endif;
                    ?>
                
            </div>
        </div>
        <?php
        // 4. On réinitialise à la requête principale (important)
        wp_reset_postdata();
        
    }
    
    function col_4($post_type){
        
      // 1. on défini ce que l'on veut
        $args = array(
            'post_type' => $post_type,
            'posts_per_page' => 10
        );

        // 2. on exécute la query
        $my_query = new WP_Query($args);
        ?>
        <div class="container">
            <div class="row">
                

                    <?php
                        if ( $my_query->have_posts() ) :
                            while ( $my_query->have_posts() ) : $my_query->the_post();
                    ?>
                         <div class="col-md-3">
                            <div id="post-<?php the_ID(); ?>" <?php post_class('sect'); ?>>
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php echo get_the_post_thumbnail(null, array(),array('class'=>'img-responsive'));?>
                                <?php get_the_post_thumbnail();?>
                                <p class="date_publish">Publié par <?php the_author();?> le <?php the_date();?> <?php wpweddu_edit_post( get_the_ID() ); ?></p> 
                                <p><?php the_excerpt(); ?></p>
                                <a class="btn btn-primary" href="<?php the_permalink(); ?>">Lire la suite<span class="glyphicon glyphicon-chevron-right"></span></a>
                            </div>
                        </div>
                    <?php
                            endwhile;
                        else :
                                get_template_part( 'template-parts/content', 'none' );

                        endif;
                    ?>
                
            </div>
        </div>
        <?php
        // 4. On réinitialise à la requête principale (important)
        wp_reset_postdata();
        
    }
}